<?php 
if ( ! defined( 'ABSPATH' ) ) exit; 

//Motif woo price calculator admin class
class MOTIF_STOCKMANAGER_ADMIN_CLASS extends MOTIF_STOCKMANAGER_MAIN_CLASS {
	
	//constructor
	public function __construct() {

		add_action('wp_loaded', array( $this, 'motif_scripts_styles_enqueue_admin'));

		add_action( 'admin_menu', array($this, 'wpdocs_register_my_custom_menu_page'));

	}

	public function wpdocs_register_my_custom_menu_page() {
	    
	   add_menu_page( 
	        __( 'WooCommerce Sotck Manager', 'motif_stock_manager' ),
	        __('WooCommerce Stock Manager', 'motif_stock_manager'),
	        'manage_options',
	        __('motif-stock-manger.php', 'motif_stock_manager'),
	        array($this,'my_custom_menu_page'),
	        MOTIF_STOCKMANAGER_INVOICES_URL.'images/motif-menu-cion.png',
	        6
	    ); 
	}

	public function my_custom_menu_page() {

		global $postid; 
		$setings = $this->motif_support_motif_settings_scripts();
		$search = isset( $_GET['s'] ) ? $_GET['s'] : '';
		// search category
		$search_cat = isset( $_GET['product_cat'] ) ? $_GET['product_cat'] : '';
		
		?>
			
		<h2 class="stock-manager-heading"><?php echo _e('WooCommerce Product Stock Manager', 'motif_stock_manager'); ?></h2>

		<div class="bootstrap-iso">

			<ul class="nav nav-pills nav-justified mindigo">
				<li class="active"><a data-toggle="tab" href="#m_pstock_tab"><strong><?php echo _e('Product Stock Manager', 'motif_stock_manager'); ?></strong></a></li>
			    <li><a data-toggle="tab" href="#m_settingopt_tab"><strong><?php echo _e('Settings Options', 'motif_stock_manager'); ?></strong></a></li>
			</ul>

			<div class="tab-content">
				<div id="m_pstock_tab" class="tab-pane fade in active">
					<?php require_once(MOTIF_STOCKMANAGER_INVOICES_DIR.'Templates/motif-product-stock-manger.php'); ?>
				</div>
				
				<div id="m_settingopt_tab" class="tab-pane fade">
					<?php require_once(MOTIF_STOCKMANAGER_INVOICES_DIR.'Templates/motif-setting-stock-options.php'); ?>
				</div>
			</div>

		</div>

	<?php }

	//Motif scripts and style admin
	public function motif_scripts_styles_enqueue_admin() { 

		wp_enqueue_script('jquery');

		wp_enqueue_script('msm-pagination-js', plugins_url( 'scripts/jPages.min.js', __FILE__ ), false );
		
		wp_enqueue_style('msm-pagination-css', plugins_url( 'css/jPages.css', __FILE__ ), false );

		wp_enqueue_script('msm-colorpicker-js', plugins_url( 'scripts/spectrum.js', __FILE__ ), false );
		
		wp_enqueue_style('msm-colopicker-css', plugins_url( 'css/spectrum.css', __FILE__ ), false );

		wp_enqueue_script('msm-parsley-js', plugins_url( 'scripts/parsley.min.js', __FILE__ ), false );

		wp_enqueue_style('msm-parsley-css', plugins_url( 'css/parsley.css', __FILE__ ), false );
	} 	

}
new MOTIF_STOCKMANAGER_ADMIN_CLASS();